/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.legendblade.network;

import com.dinzeer.legendblade.entity.DemonBladeFragments;
import com.exfantasy.mclib.Utils.SlashBlade.SlashbladeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DemonBladeMessageA {
    private final int entityId;

    public DemonBladeMessageA(int entityId) {
        this.entityId = entityId;
    }

    public DemonBladeMessageA(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    public static void handle(DemonBladeMessageA msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        LogicalSide side = context.getDirection().getReceptionSide();
        if (side == LogicalSide.SERVER) {
            context.enqueueWork(() -> DemonBladeMessageA.apply((LivingEntity)context.getSender()));
        }
        ctx.get().setPacketHandled(true);
    }

    public static void apply(LivingEntity entity) {
        ItemStack stack = entity.m_21205_();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !SlashbladeUtils.getStringNBT(tag, "translationKey").equals("item.legendblade.sevensword")) {
            return;
        }
        BlockPos center = entity.m_20097_();
        Level level = entity.m_9236_();
        List<Entity> entitiesFound = level.m_6443_(Entity.class, new AABB(center).m_82400_(12.5), a -> true).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center.m_252807_()))).toList();
        for (Entity entity2 : entitiesFound) {
            DemonBladeFragments demonBladeFragments;
            if (!(entity2 instanceof DemonBladeFragments) || (demonBladeFragments = (DemonBladeFragments)entity2).isBack()) continue;
            demonBladeFragments.setisBack(true);
            demonBladeFragments.m_146884_(demonBladeFragments.m_20182_().m_82549_(new Vec3(0.0, 1.5, 0.0)));
            demonBladeFragments.setDelay(60);
            demonBladeFragments.setEverFire(false);
            demonBladeFragments.setFire(true);
        }
    }
}

